/****** Object:  StoredProcedure [dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_PARAMETRO]    Script Date: 04/08/2014 09:57:57 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_PARAMETRO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_PARAMETRO]
GO
GO
GO
--exec P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_PARAMETRO 4
CREATE PROCEDURE P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_PARAMETRO (@CD_CTR_GRUPO INT)
AS

DECLARE @TP_PAR INT;

SET @TP_PAR = ISNULL((SELECT
							TP_PARAMETRO
						 FROM
							CG_FND_VERBA_NOTA_CREDITO_GRUPO
						 WHERE
							CD_CTR_GRUPO=@CD_CTR_GRUPO),0)
	

CREATE TABLE #RsParametro(CD_CTR_GRUPO INT,
						  ORDEM INT,
						  VLR_RESSARCIMENTO MONEY,
						  CD_PAR INT,
						  QT_ITEM MONEY,
						  VLR_ITEM MONEY,
						  PERC_DESC_ITEM MONEY,
						  TP_PARAMETRO INT,
						  DT_INI DATETIME,
						  DT_FIM DATETIME)


--Por categoria
IF @TP_PAR=0
BEGIN
	INSERT INTO 
		#RsParametro
	SELECT        
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO,
		RANK() OVER(PARTITION BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_CATEGORIA.CD_CTR_GRUPO ORDER BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_CATEG) AS ORDEM,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.VLR_RESSARCIMENTO, 
		EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_CATEGORIA.QT_IT, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_CATEGORIA.VLR_IT,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_CATEGORIA.PERC_DESC, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.TP_PARAMETRO,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_INI,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_FIM
	FROM            
		CG_FND_VERBA_NOTA_CREDITO_GRUPO
		INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_CATEGORIA ON 
			CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_CATEGORIA.CD_CTR_GRUPO
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_CATEGORIA.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
			AND CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_CATEG = EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_CATEG
	WHERE
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = @CD_CTR_GRUPO
END

--Por fabricante
IF @TP_PAR=1
BEGIN
	INSERT INTO 
		#RsParametro
	SELECT        
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO,
		RANK() OVER(PARTITION BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_FABRIC.CD_CTR_GRUPO ORDER BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_FABRIC.CD_FABRIC) AS ORDEM,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.VLR_RESSARCIMENTO, 
		EST_PROD.CD_PROD, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_FABRIC.QT_IT, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_FABRIC.VLR_IT,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_FABRIC.PERC_DESC, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.TP_PARAMETRO,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_INI,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_FIM
	FROM            
		CG_FND_VERBA_NOTA_CREDITO_GRUPO
		INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_FABRIC ON 
			CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_FABRIC.CD_CTR_GRUPO
		INNER JOIN EST_PROD ON
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_FABRIC.CD_FABRIC = EST_PROD.CD_FABRIC
	WHERE
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = @CD_CTR_GRUPO
END


--Por familia
IF @TP_PAR=2
BEGIN
	INSERT INTO 
		#RsParametro
	SELECT        
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO, 
		RANK() OVER(PARTITION BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_FAMILIA.CD_CTR_GRUPO ORDER BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA) AS ORDEM,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.VLR_RESSARCIMENTO, 
		EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_FAMILIA.QT_IT, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_FAMILIA.VLR_IT,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_FAMILIA.PERC_DESC, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.TP_PARAMETRO,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_INI,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_FIM
	FROM            
		CG_FND_VERBA_NOTA_CREDITO_GRUPO
		INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_FAMILIA ON 
			CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_FAMILIA.CD_CTR_GRUPO
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_FAMILIA.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
			AND CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA = EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_FAMILIA
	WHERE
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = @CD_CTR_GRUPO
END

--Por linha
IF @TP_PAR=3
BEGIN
	INSERT INTO 
		#RsParametro
	SELECT        
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO,
		RANK() OVER(PARTITION BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_LINHA.CD_CTR_GRUPO ORDER BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA) AS ORDEM,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.VLR_RESSARCIMENTO, 
		EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_LINHA.QT_IT, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_LINHA.VLR_IT,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_LINHA.PERC_DESC, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.TP_PARAMETRO,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_INI,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_FIM
	FROM            
		CG_FND_VERBA_NOTA_CREDITO_GRUPO
		INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_LINHA ON 
			CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_LINHA.CD_CTR_GRUPO
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_LINHA.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
			AND CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA = EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA
	WHERE
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = @CD_CTR_GRUPO
END


--Por marca
IF @TP_PAR=4
BEGIN
	INSERT INTO 
		#RsParametro
	SELECT        
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO, 
		RANK() OVER(PARTITION BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_MC.CD_CTR_GRUPO ORDER BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_MC.CD_MC) AS ORDEM,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.VLR_RESSARCIMENTO, 
		EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_MC.QT_IT, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_MC.VLR_IT,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_MC.PERC_DESC, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.TP_PARAMETRO,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_INI,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_FIM
	FROM            
		CG_FND_VERBA_NOTA_CREDITO_GRUPO
		INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_MC ON 
			CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_MC.CD_CTR_GRUPO
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_MC.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
			AND CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_MC.CD_MC = EST_PROD_EST_ARV_MERCADOLOGICA.CD_MC
	WHERE
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = @CD_CTR_GRUPO
END

--Por produto
IF @TP_PAR=5
BEGIN
	INSERT INTO 
		#RsParametro
	SELECT        
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO, 
		RANK() OVER(PARTITION BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD.CD_CTR_GRUPO ORDER BY CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD.CD_PROD) AS ORDEM,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.VLR_RESSARCIMENTO, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD.CD_PROD, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD.QT_IT, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD.VLR_IT,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD.PERC_DESC, 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.TP_PARAMETRO,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_INI,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_FIM
	FROM            
		CG_FND_VERBA_NOTA_CREDITO_GRUPO 
		INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD ON 
			CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD.CD_CTR_GRUPO
	WHERE
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = @CD_CTR_GRUPO
END

--COMO ESSE CAMPO SERA UTILIZADO PARA DIVISAO, ESSE UPDATE FOI INCLUIDO PARA TRATAR CONTRATOS COM QUANTIDADE ZERADA, OU SEJA, PARA PREVENIR DIVISAO POR ZERO
UPDATE
	#RsParametro
SET
	QT_ITEM = 1
WHERE
	QT_ITEM <= 0

SELECT
	CD_CTR_GRUPO,
	ORDEM,
	VLR_RESSARCIMENTO,
	CD_PAR,
	QT_ITEM,
	VLR_ITEM,
	PERC_DESC_ITEM,
	TP_PARAMETRO,
	DT_INI,
	DT_FIM
FROM
	#RsParametro

DROP TABLE #RsParametro 